unit SampleMainForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, clsUserDetails, clsUserDetailsCollection;

type
  TSampleMainForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnAdd: System.Windows.Forms.Button;
    btnDelete: System.Windows.Forms.Button;
    btnEdit: System.Windows.Forms.Button;
    btnClose: System.Windows.Forms.Button;
    dgCollection: System.Windows.Forms.DataGrid;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnAdd_Click(sender: System.Object; e: System.EventArgs);
    procedure btnClose_Click(sender: System.Object; e: System.EventArgs);
    procedure btnEdit_Click(sender: System.Object; e: System.EventArgs);
    procedure btnDelete_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    fCollection : TUserDetailsCollection;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TSampleMainForm))]

implementation

uses frmUserDetails;


{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TSampleMainForm.InitializeComponent;
begin
  Self.dgCollection := System.Windows.Forms.DataGrid.Create;
  Self.btnAdd := System.Windows.Forms.Button.Create;
  Self.btnDelete := System.Windows.Forms.Button.Create;
  Self.btnEdit := System.Windows.Forms.Button.Create;
  Self.btnClose := System.Windows.Forms.Button.Create;
  (System.ComponentModel.ISupportInitialize(Self.dgCollection)).BeginInit;
  Self.SuspendLayout;
  // 
  // dgCollection
  // 
  Self.dgCollection.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.dgCollection.DataMember := '';
  Self.dgCollection.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dgCollection.Location := System.Drawing.Point.Create(0, 1);
  Self.dgCollection.Name := 'dgCollection';
  Self.dgCollection.Size := System.Drawing.Size.Create(376, 255);
  Self.dgCollection.TabIndex := 0;
  // 
  // btnAdd
  // 
  Self.btnAdd.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnAdd.Location := System.Drawing.Point.Create(384, 8);
  Self.btnAdd.Name := 'btnAdd';
  Self.btnAdd.TabIndex := 1;
  Self.btnAdd.Text := 'Add...';
  Include(Self.btnAdd.Click, Self.btnAdd_Click);
  // 
  // btnDelete
  // 
  Self.btnDelete.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnDelete.Location := System.Drawing.Point.Create(384, 40);
  Self.btnDelete.Name := 'btnDelete';
  Self.btnDelete.TabIndex := 2;
  Self.btnDelete.Text := 'Delete';
  Include(Self.btnDelete.Click, Self.btnDelete_Click);
  // 
  // btnEdit
  // 
  Self.btnEdit.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnEdit.Location := System.Drawing.Point.Create(384, 72);
  Self.btnEdit.Name := 'btnEdit';
  Self.btnEdit.TabIndex := 3;
  Self.btnEdit.Text := 'Edit...';
  Include(Self.btnEdit.Click, Self.btnEdit_Click);
  // 
  // btnClose
  // 
  Self.btnClose.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnClose.Location := System.Drawing.Point.Create(384, 232);
  Self.btnClose.Name := 'btnClose';
  Self.btnClose.TabIndex := 4;
  Self.btnClose.Text := 'Close';
  Include(Self.btnClose.Click, Self.btnClose_Click);
  // 
  // TSampleMainForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(464, 262);
  Self.Controls.Add(Self.btnClose);
  Self.Controls.Add(Self.btnEdit);
  Self.Controls.Add(Self.btnDelete);
  Self.Controls.Add(Self.btnAdd);
  Self.Controls.Add(Self.dgCollection);
  Self.Name := 'TSampleMainForm';
  Self.Text := 'Databinding example app';
  (System.ComponentModel.ISupportInitialize(Self.dgCollection)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}


procedure TSampleMainForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TSampleMainForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  fCollection := TUserDetailsCollection.Create;
  dgCollection.DataSource := fCollection;
end;

procedure TSampleMainForm.btnDelete_Click(sender: System.Object; e: System.EventArgs);
var
  i : Integer;
begin
  i := BindingContext[fCollection].Position;
  fCollection.RemoveAt(i);
  CurrencyManager(BindingContext[fCollection]).Refresh;
end;

procedure TSampleMainForm.btnEdit_Click(sender: System.Object; e: System.EventArgs);
var
  User : TUser;
  dlg : TfrmUserDetails;
begin
  User := BindingContext[fCollection].Current as TUser;
  dlg := TfrmUserDetails.Create;
  dlg.User := User;
  if dlg.ShowDialog = System.Windows.Forms.DialogResult.OK then
  begin
    CurrencyManager(BindingContext[fCollection]).Refresh;
  end;

end;

procedure TSampleMainForm.btnClose_Click(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure TSampleMainForm.btnAdd_Click(sender: System.Object; e: System.EventArgs);
var
  User : TUser;
  dlg : TfrmUserDetails;
begin
  User := TUser.Create;
  dlg := TfrmUserDetails.Create;
  dlg.User := User;
  if dlg.ShowDialog = System.Windows.Forms.DialogResult.OK then
  begin
    fCollection.Add(User);
    CurrencyManager(BindingContext[fCollection]).Refresh;
  end;
end;

end.
